
# STA steering

## Usage & UCI Configuration

In order to enable STA steering please set at least *enable_sta_steer* and *use_bcn_metrics* in mapcontroller file to **1** .
There're also other UCI parameters that will be used for steering:

**/etc/config/mapcontroller**

``` shell
...
config controller 'controller'
...
        option enable_sta_steer '1'
        # enable steering of (non-bsta) client stations
        option enable_bsta_steer '0'
        # enable steering of backhauls (experimental)
        option use_bcn_metrics '1'
        # use rcpi from beacon metrics to decide on best bssid to steer to
        option use_usta_metrics '0'
        # use ul_rcpi measured as an unassociated sta as additional trigger for steering (experimental)
...
```


**/etc/config/mapagent**

``` shell
...
config wifi-radio
	...
        option util_threshold '0'
        # radio utilization - if non-zero, then checked every 5 seconds
        # it may cause sending of associated sta link metrics to the controller
        # mandate steering may be trigerred by controller in handler of the above
        ...
        option rcpi_threshold '86'
        # defaults to 130 (if unset), checked every 5 seconds
        # going below threshold value will trigger sending of associated sta link metrics to the controller
        # mandate steering may be trigerred by controller in handler of the above
	...
        option include_sta_metric '1'
        # additional trigger point on top of the previous two
        # notify controller on current link metrics (send link metrics) along the AP metrics response
        # mandate steering may be trigerred by controller in handler of the above
...
```



## Working functionality (automatic steering)
Controller initiated mandate steering is now working as follows:
Depending on the settings there'll be more or less frequent checks done by the controller. - Frequency of the checks depends on the frequency of the associated sta link metrics responses received from the nodes, which depends on the settings as explained earlier (util_threshold, rcpi_threshold, include_sta_metric). Controller will check if RCPI goes below some threshold (currently defined to 160 in controller). If so, then controller will request for beacon metrics and/or unassociated STA link metrics for given client. After some time it will then compare current RCPI of that given station with the values obtained in metrics and only try to (BTM) steer that station if there's a better candidate found. - The delta RCPI of at least 10 is required.

## UBUS call inititated steering
In order to steer STA one can use existing UBUS API as follows

``` shell
ubus call map.controller steer '{"agent":"46:d4:37:6a:f7:d0", "src_bssid":"7e:d4:37:6a:f7:d8", "sta":["e0:d4:e8:79:c4:ee"], "steer_req_mode":true, "target_bssid":["44:d4:37:6a:f4:cf"]}'

```

The parameters are:
- agent - alid of the agent node of the source BSSID
- src_bssid - source BSSID to which the STA is currently connecte
- sta - MAC address of the STA to be steered
- steer_req_mode - true for mandate, false for opportunity (experimental)
- target_bssid - target BSSID

## Known issues / missing features
- beacon metrics used for steering decission are being requested on hardcoded opclass/channel pairs
- opportunity window steering
- agent initiated rcpi based steering
- code refactoring of source code - move steering into separate module
- verify test specification compliance (i.e. WFA tests)
- use of unassociated STA link metrics for steering decission
